import numpy as np
KPC_TO_M = 3.085677581491367e19

def vflat_pred_ar(c_ms, alphaP, UGM_phys_m, R_obs_m, R_G_kpc, lambda_G=1.0):
    Rm = R_G_kpc * KPC_TO_M
    chi = (Rm**2)/(UGM_phys_m * R_obs_m)
    return c_ms * np.sqrt(max(0.0, alphaP*lambda_G*chi))

def vflat_pred_j(c_ms, J_m2, R_G_kpc):
    Rm = R_G_kpc * KPC_TO_M
    return c_ms * Rm * np.sqrt(max(0.0, J_m2))
